using System;
using System.Configuration;
using gov.va.med.vbecs.ExceptionManagement;

namespace gov.va.med.vbecs.Common
{
	
	#region Header
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Margaret Jablonski</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>2/18/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Exception class used to represent row version related errors.  
	///</summary>
	///

	#endregion
	
	public class RowVersionException : BaseApplicationException
	{

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/18/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3736"> 
		///		<ExpectedInput>Message input string</ExpectedInput>
		///		<ExpectedOutput>Valid RowVersionException class with input string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3737"> 
		///		<ExpectedInput>Null value</ExpectedInput>
		///		<ExpectedOutput>Generic exception error message</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// RowVersionException
		/// </summary>
		/// <param name="message"></param>
		public RowVersionException(string message): base(message)
		{
		}
	}
}
